//SMAA filter history from Jorge Jimenez
//http://www.klayge.org/material/4_11/Filmic%20SMAA%20v7.pdf

vec3 smaa_filter(sampler2D colortex, vec2 coord, vec2 pixel){
    vec2 position = coord * pixel;
    vec2 center_position = floor(position - 0.5) + 0.5;

    vec2 f = position - center_position;
    vec2 ff = f * f;
    vec2 fff = f * ff;

    const float c = 0.5;

    vec2 w0 = -c * fff + 2.0 * c * ff - c * f;
    vec2 w1 = (2.0 - c) * fff - (3.0 - c) * ff + 1.0;
    vec2 w2 = -(2.0 - c) * fff + (3.0 - 2.0 * c) * ff + c * f;
    vec2 w3 = c * fff - c * ff;

    vec2 w12 = w1 + w2;
    vec2 tc12 = (center_position + w2 / w12) / pixel;

    vec2 tc0 = (center_position - 1.0) / pixel;
    vec2 tc3 = (center_position + 2.0) / pixel;

    vec4 color = vec4(texture2(colortex, vec2(tc12.x, tc0.y)).rgb, 1.0) * (w12.x * w0.y) +
                 vec4(texture2(colortex, vec2(tc0.x, tc12.y)).rgb, 1.0) * (w0.x * w12.y) +
                 vec4(texture2(colortex, vec2(tc12.x, tc12.y)).rgb, 1.0) * (w12.x * w12.y) +
                 vec4(texture2(colortex, vec2(tc3.x, tc12.y)).rgb, 1.0) * (w3.x * w12.y) +
                 vec4(texture2(colortex, vec2(tc12.x, tc3.y)).rgb, 1.0) * (w12.x * w3.y);

    return max0(color.rgb / color.a);
}

vec3 closest_fragment_3x3(sampler2D depth_tex, vec2 coord, vec2 pixel){
    float depth0 = texture2(depth_tex, coord).x;

    float depth1 = texture2(depth_tex, coord + vec2(1.0, 0.0) * pixel).x;
    float depth2 = texture2(depth_tex, coord + vec2(-1.0, 0.0) * pixel).x;
    float depth3 = texture2(depth_tex, coord + vec2(0.0, 1.0) * pixel).x;
    float depth4 = texture2(depth_tex, coord + vec2(0.0, -1.0) * pixel).x;

    float depth5 = texture2(depth_tex, coord + vec2(1.0, 1.0) * pixel).x;
    float depth6 = texture2(depth_tex, coord + vec2(-1.0, 1.0) * pixel).x;
    float depth7 = texture2(depth_tex, coord + vec2(1.0, -1.0) * pixel).x;
    float depth8 = texture2(depth_tex, coord + vec2(-1.0, -1.0) * pixel).x;

    vec3 position = vec3(0.0, 0.0, depth0);

    if(position.z > depth1) position.xy = vec2(1.0, 0.0); position.z = depth1;
    if(position.z > depth2) position.xy = vec2(-1.0, 0.0); position.z = depth2;
    if(position.z > depth3) position.xy = vec2(0.0, 1.0); position.z = depth3;
    if(position.z > depth4) position.xy = vec2(1.0, -1.0); position.z = depth4;

    if(position.z > depth5) position.xy = vec2(1.0, 1.0); position.z = depth5;
    if(position.z > depth6) position.xy = vec2(-1.0, 1.0); position.z = depth6;
    if(position.z > depth7) position.xy = vec2(1.0, -1.0); position.z = depth7;
    if(position.z > depth8) position.xy = vec2(-1.0, -1.0); position.z = depth8;

	return vec3(coord + pixel * position.xy, position.z);
}

#if defined COMPOSITE11
    vec3 current_color(vec2 coord){
        vec3 color = texture2(colortex7, coord + jitter * 0.5).xyz;
             color = gamma_to_linear(color);

        return color;
    }

    vec3 previous_color(vec2 coord){
        vec3 color = smaa_filter(colortex8, coord, texel);
             color = gamma_to_linear(color);

        return color;
    }

    vec3 ClipAABB(vec3 prevSample, vec3 aabbMin, vec3 aabbMax){
        vec3 p_clip = 0.5 * (aabbMax + aabbMin);
        vec3 e_clip = 0.5 * (aabbMax - aabbMin) + 1e-7;

        vec3 v_clip = prevSample - p_clip;
        vec3 v_unit = v_clip.xyz / e_clip;
        vec3 a_unit = abs(v_unit);
        float ma_unit = max(a_unit.x, max(a_unit.y, a_unit.z));

        if (ma_unit > 1.0)
            return p_clip + v_clip / ma_unit;
        else
            return prevSample;
    }
   
    vec3 temporal_aa(vec2 coord){
        temporal_settings ts = temporal_s();

        vec3 view_position = closest_fragment_3x3(depthtex0, coord, inverse_texel);

        vec2 position = screen_velocity(view_position);
        vec2 velocity = view_position.z < 0.7 ? coord : coord - position;
        vec2 projection = 0.5 - abs(fract(velocity * texel) - 0.5);

        vec3 current = current_color(coord);

        vec3 current0 = current_color(coord + inverse_texel * vec2( 1.0,  0.0));
        vec3 current1 = current_color(coord + inverse_texel * vec2(-1.0,  0.0));
        vec3 current2 = current_color(coord + inverse_texel * vec2( 0.0,  1.0));
        vec3 current3 = current_color(coord + inverse_texel * vec2( 1.0, -1.0));

        vec3 current4 = current_color(coord + inverse_texel * vec2( 1.0,  1.0));
        vec3 current5 = current_color(coord + inverse_texel * vec2(-1.0,  1.0));
        vec3 current6 = current_color(coord + inverse_texel * vec2( 1.0, -1.0));
        vec3 current7 = current_color(coord + inverse_texel * vec2(-1.0, -1.0));

        vec3 current_min = min(current0, min(current1, min(current2, min(current3, min(current, min(current4, min(current5, min(current6, current7))))))));
        vec3 current_max = max(current0, max(current1, max(current2, max(current3, max(current, max(current4, max(current5, max(current6, current7))))))));
        vec3 current_avg = (current + current0 + current1 + current2 + current3 + current4 + current5 + current6 + current7) * rcp(9.0);

        vec3 current_min_rounded = min(current3, min(current1, min(current, min(current0, current2))));
        vec3 current_max_rounded = max(current3, max(current1, max(current, max(current0, current2))));
        vec3 current_avg_rounded = (current + current0 + current1 + current2 + current3) * rcp(5.0);

        current_min = 0.5 * (current_min + current_min_rounded);
        current_max = 0.5 * (current_max + current_max_rounded);
        current_avg = 0.5 * (current_avg + current_avg_rounded);

        current = linear_to_gamma(current);

        vec3 previous = previous_color(velocity);
             previous = ClipAABB(previous, current_min, current_max);
             previous = linear_to_gamma(previous);

        float lum0 = luminance(current);
        float lum1 = luminance(previous);
        
        float weight = saturate(velocity) != velocity ? 0.0 : ts.weight;
              weight *= sqrt(projection.x * projection.y) * ts.reprojection + (1.0 - ts.reprojection);
              weight *= 1.0 + (distance(previous, current) / luminance(previous)) * 0.5;
              weight = saturate(weight);

        #ifdef TAA
            return mix(current, previous, weight);
        #else
            return texture2(colortex7, coord).xyz;
        #endif
    }
#elif defined COMPOSITE12
    vec3 motion_blur(temporal_settings ts, vec2 coord, vec2 velocity, float depth){
        vec2 offset = coord * texel + sin(frame_16);
        vec2 noise = rand2(offset);

        velocity = 0.05 * velocity / frameTime;
        velocity = clamp(velocity, -ts.velocity_max, ts.velocity_max);
        velocity = velocity * ts.strength;

        if(depth < 0.7) velocity = vec2(0);

        vec2 increment = velocity / ts.steps;
        vec2 position = coord + increment * noise;

        vec3 color = vec3(0);
        float weight = 0;

        for(int i = -ts.steps; i <= ts.steps; i++){
            float w = filter_gaussian(i, 2.0);
            
            color += w * texture2(colortex8, position + i * increment).rgb;
            weight += w;
        }

        return color / weight;
    }
#endif